package com.twentyfouri.tvlauncher.setupwizard

import android.content.Context
import android.util.Log
import android.view.inputmethod.EditorInfo
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentials
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentialsPassword
import com.twentyfouri.smartmodel.serialization.SmartDataObject
import com.twentyfouri.smartmodel.smartvideo.SmartVideoFlowSmartApi
import com.twentyfouri.smartmodel.smartvideo.reference.SmartVideoUserProfileReference
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.common.utils.DeviceId
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.Screens
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.PasswordScreenModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.PinScreenModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.RecommendationsScreenModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.UsernameScreenModel
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import java.io.OutputStreamWriter
import java.net.HttpURLConnection
import java.net.URL
import java.net.URLEncoder

class Flavor : FlavorBase() {

    override val pinScreenList: List<Screens> = emptyList()

    override val usernameScreenList = listOf(
        Screens.UsernameScreen,
        Screens.PasswordScreen,
        Screens.RecommendationsScreen
    )

    override fun getLoginCredentialsType(loginCredentials: LoginCredentials): SmartLoginCredentials {
        return SmartLoginCredentialsPassword(loginCredentials.username.orEmpty(), loginCredentials.password.orEmpty())
    }

    override fun getImeAction(currentScreen: Screens, screens: List<Screens>): Int {
        return if (currentScreen == Screens.PasswordScreen) EditorInfo.IME_ACTION_DONE
        else EditorInfo.IME_ACTION_NEXT
    }

    override fun getInitialSetupData(smartApi: FlowSmartApi, context: Context): String? {
        if (smartApi !is SmartVideoFlowSmartApi) throw IllegalArgumentException("Wrong type of eventsOnChannel")
        val sp = context.getSharedPreferences("savedSession", Context.MODE_PRIVATE)
        return sp.getString("data", null) ?: return null
    }

    override fun getUserProfileReference(userName: String) = SmartVideoUserProfileReference(userName)

    override fun gdprProfileChangeObject(isGdrpAccepted: Boolean?) = SmartDataObject()

    override fun isGdprAcceptedProfile(extras: SmartDataObject, modelRecommendations: Boolean) = true

    override fun processLogin(credentials: SmartLoginCredentials) {
        val serialNumber = URLEncoder.encode(DeviceId.getDeviceIdViaProperties(), "utf-8")
        val username = URLEncoder.encode((credentials as SmartLoginCredentialsPassword).username, "utf-8")
        GlobalScope.launch {
            try {
                URL("https://provisioning.youfone.nl/Amino/service.svc/device?serialNumber=$serialNumber&email=$username")
                    .openConnection()
                    .let {
                        it as HttpURLConnection
                    }.apply {
                        setRequestProperty("Content-Type", "application/json; charset=utf-8")
                        requestMethod = "POST"
                        doOutput = true
                        val outputWriter = OutputStreamWriter(outputStream)
                        outputWriter.flush()
                    }.let {
                        if (it.responseCode == 200)
                            Timber.tag("Youfone provisioning").d("sucess")
                        else
                            Timber.tag("Youfone provisioning").d("error")
                    }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    fun processErrorMessage(code: String, resourceRepository: ResourceRepository): String {
        return if (code == "401") 
            "${resourceRepository.getString(R.string.wrong_credentials)}"
        else
            "${resourceRepository.getString(R.string.wrong_credentials)}${resourceRepository.getString(R.string.error_code)}$code"
    }
}