package com.twentyfouri.tvlauncher.setupwizard.global

import android.app.Application
import android.content.Context
import com.google.firebase.analytics.FirebaseAnalytics
import com.twentyfouri.tvlauncher.common.ui.ForceLocaleHelper

class SetupWizardApplication : Application() {
    private lateinit var firebaseAnalytics: FirebaseAnalytics

    override fun onCreate() {
        super.onCreate()

        firebaseAnalytics = FirebaseAnalytics.getInstance(this)
    }

    override fun attachBaseContext(base: Context) =
        super.attachBaseContext(ForceLocaleHelper.onAttachBaseContextApplication(base))
}