package com.twentyfouri.searchproxy.resourcegen

import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonConfiguration
import java.io.File

object Main {
    @JvmStatic
    fun main(args: Array<String>) {
        require(args.isNotEmpty()) { "No argument" }
        val arguments = parseArgsJson(args[0])

        val srcDir = ResourceDirs(File(arguments.src))
        val destDir = ResourceDirs(File(arguments.dest))

        StringResourceVariants.forAllVariants(srcDir, arguments.flavors) { strings, variant, lang ->
            val applicationId =
                arguments.baseApplicationId + variant.getVariantApplicationIdSuffix()

            val newStrings = StringResources()
                .add(
                    name = "app_name",
                    value = strings.format(
                        "app_name_base",
                        strings["app_name_product"]
                    )
                )
                .add(
                    name = "app_description",
                    value = strings.format(
                        "app_description_base",
                        strings["app_name_product"]
                    )
                )

            if (lang == "") newStrings
                .add(
                    name = "app_package",
                    value = applicationId,
                    translatable = false
                )
                .add(
                    name = "search_authority",
                    value = applicationId,
                    translatable = false
                )
                .add(
                    name = "intent_suggestion_data",
                    value = strings.format(
                        "intent_suggestion_data_base",
                        strings["target_search_package"]),
                    translatable = false
                )

            destDir.writeStrings(variant.getVariantName(), newStrings, lang.orEmpty())
        }
    }

    fun parseArgsJson(args: String): Arguments {
        val json = Json(JsonConfiguration.Stable)
        return json.parse(Arguments.serializer(), args)
    }
}