package com.twentyfouri.tvlauncher.common.utils

import android.content.Context
import android.util.Log
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import com.twentyfouri.tvlauncher.common.ui.SemaphoreState
import org.joda.time.DateTime
import timber.log.Timber
import java.util.*
import kotlin.concurrent.schedule

class NetworkQualityCheckTimer(val context: Context) {
    private val CONNECTION_CHECK_TICK = 1000 * 60L
    private var timerTask: TimerTask? = null
    private var goalTime: Long = -1L
    private var remainingTime: Long = -1L
    private var isPaused = true

    var isHomeVisible = false
        set(value) {
            if (field != value) {
                field = value
                checkTimer()
            }
        }

    var isPlayerPlaying = false
        set(value) {
            if (field != value) {
                field = value
                checkTimer()
            }
        }

    init {
        Timber.d("START")
    }

    private fun pause() {
        if (isPaused) return
        isPaused = true
        Timber.d("PAUSE")

        timerTask?.cancel()
        timerTask = null
        remainingTime = if (goalTime != -1L) {
            goalTime - DateTime.now().millis
        } else {
            -1L
        }
    }

    private fun resume() {
        if (!isPaused) return
        isPaused = false
        Timber.d("RESUME")

        if (remainingTime <= -1L) {
            remainingTime = CONNECTION_CHECK_TICK
            goalTime = DateTime.now().millis + CONNECTION_CHECK_TICK
        }
        startTimer()
    }

    private fun startTimer() {
        timerTask?.cancel()
        timerTask = null
        timerTask = Timer("connection_check", true).schedule(remainingTime) {
            val networkInfo = NetworkInfo.getActiveConnectionInfo(context)
            YouboraAnalytics.getInstance(context).reportYouboraNetworkConnection(context, networkInfo)
            val networkQualityState = NetworkInfo.getCurrentNetworkQualityState(networkInfo)
            SharedPreferencesUtils.putConnectionSemaphoreState(networkQualityState)
            Timber.d("FINISHED  ${networkQualityState.name}")
            restart()
        }

    }

    fun restart() {
        remainingTime = -1L
        goalTime = -1L
        isPaused = true
        resume()
    }


    private fun checkTimer() {
        if (isHomeVisible || isPlayerPlaying) resume()
        else pause()
    }

    fun cancel() {
        timerTask?.cancel()
        timerTask = null
    }
}