package com.twentyfouri.tvlauncher.common.utils

import android.os.Build
import android.util.Log
import timber.log.Timber
import java.io.BufferedReader
import java.io.InputStreamReader

class DeviceProperties {

    private val properties: ArrayList<Pair<String,String>> = arrayListOf()

    init {
        try {
            // Run the command
            val process = Runtime.getRuntime().exec("getprop")
            val bufferedReader = BufferedReader(InputStreamReader(process.inputStream))
            bufferedReader.useLines { lines ->
                lines.forEach {line ->
                    properties.add(Pair(
                            line.substringAfter("[").substringBefore("]"),
                            line.substringAfterLast("[").substringBefore("]")
                    ))
                }
            }
        } catch (e: Exception) {
            Timber.d("reading properties failed: ${e.message}")
        }
    }

    fun getProperty(key: String): String? {
        return properties.find { it.first == key }?.second
    }
}