package com.twentyfouri.tvlauncher.common.utils

import android.net.Uri

class DeepLinkingUtils {

    fun buildUri(scheme: String, authority: String, params: HashMap<String, String>): Uri? {
        val uriBuilder = Uri.Builder()
        uriBuilder.scheme(scheme)
        uriBuilder.authority(authority)

        params.forEach { (key, value) ->
            uriBuilder.appendQueryParameter(key, value)
        }

        return uriBuilder.build()
    }

    fun buildParams(uri: Uri?, params: HashMap<String, String>): Uri? {
        val uriBuilder: Uri.Builder = if (uri == null) {
            Uri.Builder()
        } else {
            uri.buildUpon()
        }
        params.forEach { (key, value) ->
            uriBuilder.appendQueryParameter(key, value)
        }

        return uriBuilder.build()
    }
}