package com.twentyfouri.tvlauncher.common.utils

import android.view.View
import androidx.databinding.BindingAdapter
import com.twentyfouri.tvlauncher.common.ui.Semaphore
import com.twentyfouri.tvlauncher.common.ui.SemaphoreState

@BindingAdapter("onFocusListener")
fun View.setFocusListener(listener: View.OnFocusChangeListener?) {
    if (listener != null)
        this.onFocusChangeListener = listener
}

@BindingAdapter("onKeyListener")
fun View.setOnKeyListener(listener: View.OnKeyListener) {
    this.setOnKeyListener(listener)
}

@BindingAdapter("state")
fun Semaphore.setState(state: SemaphoreState?) {
    if(state == null) {
        visibility = View.GONE
        return
    }

    if(visibility == View.GONE) visibility = View.VISIBLE
    setLights(state)
}