package com.twentyfouri.tvlauncher.common.ui.fading

/*
 * All views which should be animated by FadingViewController need to implement this interface.
 * When creating new implementations see FadingTextView and FadingImageView and their
 *  - setController
 *  - onAttachedToWindow
 *  - onDetachedFromWindow
 * methods. Those are important to support single and group animation.
 *
 * Method onFadedOut is called just when view is completely invisible (its alpha is 0) so it can change it state (text for example).
 * onFadeOutStarted is called when fade OUT is initiated, even multiple times if multiple views are causing fade OUT.
 * onFadeInFinished is called when alpha is back on 1, so views are completely visible.
 *
 * FadingTextView and FadingImageView currently don't need any special action upon onFadeOutStarted/onFadeInFinished so those are not implemented there but
 * can be used in new implementations.
 *
 * getControllerId provide ID to be used in group animation. To identify group controller.
 */
interface FadingViewInterface {
    fun onFadeOutStarted() {}
    fun onFadedOut() {}
    fun onFadeInFinished() {}
    fun getControllerId(): Int
}