package com.twentyfouri.tvlauncher.common.ui.fading

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup

/*
 * This is connection point for multiple views which should be animated together (something like group identifier).
 * It is looking in view hierarchy for any view which have set "fadingController" property to same ID as this FadingControllerView.
 * Those views do not need to be in same hierarchy level (can be spread around the layouts).
 * All those views then using one same FadingController.
 *
 * Only important for FadingControllerView is to set ID property android:id="@+id/....." in layout
 * All the other values are not important. This view can be placed anywhere in the layout.
 */
class FadingControllerView @JvmOverloads constructor(
        context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : View(context, attrs, defStyleAttr) {

    val fadingController = FadingController()

    private fun findFadingViews(v: View): ArrayList<FadingViewInterface> {
        val result = ArrayList<FadingViewInterface>()
        if(v is FadingViewInterface && v.getControllerId() == id) result.add(v)

        if (v !is ViewGroup) return result

        for (i in 0 until v.childCount) {
            result.addAll(findFadingViews(v.getChildAt(i)))
        }
        return result
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        fadingController.removeAndAddAllViews(findFadingViews(rootView))
    }

    override fun onDetachedFromWindow() {
        fadingController.detach()
        super.onDetachedFromWindow()
    }

}