package com.twentyfouri.tvlauncher.common.extensions

inline fun <T> T.ifTrue(block: () -> Unit): T {
    if (this == true) block()
    return this
}

inline fun <T> T.ifFalse(block: () -> Unit): T {
    if (this == false) block()
    return this
}

inline fun <T> T.ifElse(block: () -> Unit): T {
    if (this != true) block()
    return this
}

inline fun <T> T.ifNull(block: () -> Unit): T {
    if (this == null) block()
    return this
}

inline fun <T> T.ifNotNull(block: () -> Unit): T {
    if (this != null) block()
    return this
}

inline fun <T,S> T.ifNotEqualTo(other: S, block: () -> Unit): T {
    if (this != other) block()
    return this
}

inline fun <T,S> T.ifEqualTo(other: S, block: () -> Unit): T {
    if (this == other) block()
    return this
}