package com.twentyfouri.tvlauncher.common.data

import android.content.Context
import androidx.room.Room
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class SetupDataRepository(private val dao: SetupDataDao) {

    companion object {
        private var instance: SetupDataRepository? = null
        const val CREDENTIALS_ROW_ID = 0

        fun getInstance(context: Context) = instance ?: synchronized(this) {
            SetupDataRepository(getCredentialsDao(context)).also { instance = it} }

        fun removeInstance() {
            instance = null
        }

        fun getCredentialsDao(context: Context) = Room
            .databaseBuilder(context.applicationContext, com.twentyfouri.tvlauncher.common.data.Database::class.java, "database")
            .fallbackToDestructiveMigration() //TODO Delete this line after db upgrade
            .build()
            .SetupDataDao()
    }

    suspend fun getSetupDataObject() = withContext(Dispatchers.IO) { dao.getAll().getOrNull(CREDENTIALS_ROW_ID) }

    suspend fun removeCredentials() = withContext(Dispatchers.IO) { dao.deleteById(CREDENTIALS_ROW_ID.toLong()) }

    suspend fun getSetupData() = getSetupDataObject()?.getSetupData()

    fun loadCredentialsObject(process: (SetupData?) -> Unit) {
        CoroutineScope(Dispatchers.IO).launch {
            val credentials = getSetupDataObject()
            withContext(Dispatchers.Main) {
                process(credentials)
            }
        }
    }
}