package com.twentyfouri.tvlauncher.common.data

import android.content.Context
import android.content.res.ColorStateList
import android.util.TypedValue


class ResourceRepository(
    context: Context
) {
    private val appContext = context.applicationContext

    fun getString(resId: Int) = appContext.getString(resId)

    fun getString(resId: Int, vararg values: Any) = appContext.getString(resId, *values)

    fun getDimensionPixelSize(resId: Int) = appContext.resources.getDimensionPixelSize(resId)

    fun getInteger(resId: Int) = appContext.resources.getInteger(resId)

    fun getColor(resId: Int) = appContext.getColor(resId)

    fun getDrawable(resId: Int) = appContext.getDrawable(resId)

    fun getPixelSizeFromDimens(dimId: Int) = appContext.resources.getDimension(dimId)

    fun getFloat(resId: Int): Float {
        val outValue = TypedValue()
        appContext.resources.getValue(resId, outValue, true)
        return outValue.float
    }

    fun getColorStateList(resId: Int): ColorStateList =
        appContext.resources.getColorStateList(resId, null)
}