package com.twentyfouri.tvlauncher.common.data

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.smartmodel.model.user.SmartUserProfile
import com.twentyfouri.smartmodel.model.user.SmartUserProfileChange
import com.twentyfouri.tvlauncher.common.Flavor
import com.twentyfouri.tvlauncher.common.data.apihandler.ApiHandler
import kotlinx.coroutines.flow.first

class PersonalSettingsRepository(
    private val setupDataRepository: SetupDataRepository,
    private val smartApi: FlowSmartApi,
    private val apiHandler: ApiHandler
) {
    fun getCurrentProfileLD(): LiveData<SmartUserProfile> {
        val currentProfileLD = MutableLiveData<SmartUserProfile>()
        apiHandler.joinPreviousOrLaunchNew(
            synchronizedJobName = "getCurrentProfileLD",
            block = {
                currentProfileLD.postValue(smartApi.getProfiles().first().lastOrNull())
            }
        )
        return currentProfileLD
    }

    fun updateCurrentProfileLD(change: SmartUserProfileChange): LiveData<SmartUserProfile> {
        val currentProfileLD = MutableLiveData<SmartUserProfile>()
        apiHandler.launchNew {
            currentProfileLD.postValue(smartApi.updateProfile(change).first())
        }
        return currentProfileLD
    }

    fun getUserNameLD(): LiveData<String> {
        val name = MutableLiveData<String>()
        apiHandler.joinPreviousOrLaunchNew(
            synchronizedJobName = "getUserNameLD",
            block = {
                val setupData = setupDataRepository.getSetupData()
                val ss = Flavor().getUsername(setupData)
                name.postValue(ss)
            }
        )
        return name
    }

    fun updateParentalRule(): LiveData<List<String>?>{
        val parentalRules = MutableLiveData<List<String>?>()
        apiHandler.joinPreviousOrLaunchNew(
                synchronizedJobName = "updateParentalRule",
                block = {
                   parentalRules.postValue(Flavor().updateUserParentalRule(smartApi))
                }
        )
        return parentalRules
    }
}