package com.twentyfouri.tvlauncher.widgets.leanback;

import android.view.View;

import static androidx.recyclerview.widget.RecyclerView.HORIZONTAL;
import static androidx.recyclerview.widget.RecyclerView.VERTICAL;

public class ItemAlignment {

    final static class Axis extends ItemAlignmentFacet.ItemAlignmentDef {
        private int mOrientation;

        Axis(int orientation) {
            mOrientation = orientation;
        }

        /**
         * get alignment position relative to optical left/top of itemView.
         */
        public int getAlignmentPosition(View itemView) {
            return ItemAlignmentFacetHelper.getAlignmentPosition(itemView, this, mOrientation);
        }
    }

    private int mOrientation = HORIZONTAL;

    final public ItemAlignment.Axis vertical = new ItemAlignment.Axis(VERTICAL);

    final public ItemAlignment.Axis horizontal = new ItemAlignment.Axis(HORIZONTAL);

    private ItemAlignment.Axis mMainAxis = horizontal;

    private ItemAlignment.Axis mSecondAxis = vertical;

    final public ItemAlignment.Axis mainAxis() {
        return mMainAxis;
    }

    final public ItemAlignment.Axis secondAxis() {
        return mSecondAxis;
    }

    final public void setOrientation(int orientation) {
        mOrientation = orientation;
        if (mOrientation == HORIZONTAL) {
            mMainAxis = horizontal;
            mSecondAxis = vertical;
        } else {
            mMainAxis = vertical;
            mSecondAxis = horizontal;
        }
    }

    final public int getOrientation() {
        return mOrientation;
    }


}
