package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.content.res.TypedArray
import android.util.AttributeSet
import androidx.appcompat.widget.SwitchCompat
import com.twentyfouri.tvlauncher.R

class SwitchView @JvmOverloads constructor(
    context: Context, val attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : SwitchCompat(context, attrs, defStyleAttr) {

    companion object {
        val TAG: String = SwitchView::class.java.simpleName
    }

    private var mTrackWidth: Float? = null

    init {
        val mAttributes: TypedArray = context.obtainStyledAttributes(attrs, R.styleable.SwitchView)
        mTrackWidth = mAttributes.getDimension(R.styleable.SwitchView_trackWidth, 0f)
        mAttributes.recycle()
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)

        try {
            // We access mSwitchWidth to set its value and override its dependency on thumb and text size.
            mTrackWidth?.let {
                val mSwitchWidth = SwitchCompat::class.java.getDeclaredField("mSwitchWidth")
                mSwitchWidth.isAccessible = true
                mSwitchWidth.setInt(this, Math.round(it))
            }
        } catch (e: NoSuchFieldException) {
            e.printStackTrace()
        } catch (e: IllegalAccessException) {
            e.printStackTrace()
        }
    }
}