package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import com.twentyfouri.tvlauncher.databinding.PlayerNumberZapBinding
import com.twentyfouri.tvlauncher.extensions.beGone
import com.twentyfouri.tvlauncher.extensions.beVisible

class PlayerUINumberZap @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
): FrameLayout(context, attrs, defStyleAttr) {

    val binding: PlayerNumberZapBinding = PlayerNumberZapBinding.inflate(LayoutInflater.from(context), this, true)

    fun setNumber(number: String) {
        binding.zappNumber.text = number
        if (number == "") {
            binding.zappBackground.beGone()
        } else {
            binding.zappBackground.beVisible()
        }
    }
}