package com.twentyfouri.tvlauncher.widgets

import android.content.Context
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.Observer
import com.twentyfouri.smartexoplayer.ui.StandardControlsHelper
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.databinding.PlayerControlsCatchupBinding
import com.twentyfouri.tvlauncher.di.viewModel
import com.twentyfouri.tvlauncher.viewmodels.PlayerUICatchupViewModel

class PlayerUICatchup(context: Context) : PlayerUIBase(context) {

    override val viewModel: PlayerUICatchupViewModel by viewModel()

    override val binding = DataBindingUtil.inflate<PlayerControlsCatchupBinding>(
            LayoutInflater.from(context),
            R.layout.player_controls_catchup,
            this,
            true
    )

    init {
        val lifecycleOwner = context as LifecycleOwner
        binding.lifecycleOwner = lifecycleOwner
        binding.viewModel = viewModel
        viewModel.ageRatings.observe(lifecycleOwner, Observer { binding.mediaRestrictionIcons.viewModel.setContentIcons(it) })
    }

    override val standardHelpers: List<StandardControlsHelper> = listOf(
            hidingHelper, timerHelper
    )

    override fun getToastBottomOffset(): Int {
        return super.getToastBottomOffset() + ((binding.bottomGuideline.layoutParams as? ConstraintLayout.LayoutParams)?.guideEnd ?: 0)
    }

}