package com.twentyfouri.tvlauncher.viewmodels

import android.content.res.Resources
import android.graphics.drawable.Drawable
import android.view.View
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import com.twentyfouri.androidcore.utils.ImageSpecification
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.widgets.SettingsItemType

class SettingsItemViewModel(
    resources: Resources
): ViewModel() {
    private val _type = MutableLiveData<SettingsItemType>().apply { value = SettingsItemType.UNKNOWN }
    private val _switchOn = MutableLiveData<Boolean>().apply { value = false }
    private val _title = MutableLiveData<String>().apply { value = "" }
    private val _subtitle = MutableLiveData<String>().apply { value = "" }
    private val _label = MutableLiveData<String>().apply { value = _type.value.toString() }
    private val _icon = MutableLiveData<ImageSpecification>()

    val type: LiveData<SettingsItemType> = _type
    val switchOn: LiveData<Boolean> = _switchOn
    val title: LiveData<String> = _title
    val subtitle: LiveData<String> = _subtitle
    val label: LiveData<String> = _label
    val iconDrawable: LiveData<ImageSpecification> = _icon
    val switchVisibility: LiveData<Int>
    val titleVisibility: LiveData<Int>
    val labelVisibility: LiveData<Int>
    val sectionLabelVisibility: LiveData<Int>
    val imageVisibility: LiveData<Int>
    var position = -1

    init {
        switchVisibility = Transformations.map(type) {
            when (it) {
                SettingsItemType.SWITCH -> View.VISIBLE
                else -> View.GONE
            }
        }
        titleVisibility = Transformations.map(type) {
            when (it) {
                SettingsItemType.SWITCH, SettingsItemType.LABEL, SettingsItemType.TITLE_SUBTITLE -> View.VISIBLE
                else -> View.GONE
            }
        }
        labelVisibility = Transformations.map(type) {
            when (it) {
                SettingsItemType.ICON, SettingsItemType.LABEL, SettingsItemType.UNKNOWN -> View.VISIBLE
                else -> View.GONE
            }
        }
        sectionLabelVisibility = Transformations.map(type) {
            when (it) {
                SettingsItemType.SECTION_LABEL -> View.VISIBLE
                else -> View.GONE
            }
        }
        imageVisibility = Transformations.map(type) {
            when (it) {
                SettingsItemType.TITLE_WITH_ICON -> View.VISIBLE
                else -> View.GONE
            }
        }
    }

    fun setFromListPickerItem(position: Int, item: ListPickerItem) {
        this.position = position
        _label.value = item.label
        _title.value = item.title
        _subtitle.value = item.subtitle
        _type.value = item.type
        if (item.icon != null) _icon.value = item.icon!!
    }

    fun setFromData(itemType: SettingsItemType, labelText: String? = null, titleText: String? = null, subtitleText: String? = null, itemIcon: ImageSpecification? = null) {
        _type.value = itemType
        if (labelText != null) _label.value = labelText
        if (titleText != null) _title.value = titleText
        if (subtitleText != null) _subtitle.value = subtitleText
        if (itemIcon != null) _icon.value = itemIcon!!
    }

    fun setChecked(boolean: Boolean) { _switchOn.value = boolean }
}