package com.twentyfouri.tvlauncher.viewmodels

import androidx.lifecycle.LifecycleOwner
import com.twentyfouri.smartexoplayer.SmartPlayer
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaReference
import com.twentyfouri.smartmodel.model.media.SmartMediaDetail
import com.twentyfouri.smartmodel.model.media.SmartMediaStream
import com.twentyfouri.smartmodel.model.media.SmartSeekingRuleType
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.common.provider.TimeProvider
import com.twentyfouri.tvlauncher.data.DateTimeRepository
import com.twentyfouri.tvlauncher.data.EpgRepository
import com.twentyfouri.tvlauncher.data.MetadataRepository
import kotlinx.coroutines.CoroutineScope
import kotlin.math.abs

/**
 *         SLW            <- LW ->          ELW/CT
 *          |-------------------|--------------|
 *                             LP
 *                 |---------------------------------------|
 *                ES                <- EW ->               EE
 *                 |------------|--------------|
 *                             PP             SP
 *
 * LW = live window (duration)
 * SLW = start of live window
 * ELW = end of live window
 * LP = position in live stream
 * CT = current time (real)
 * EW = event window
 * ES = event start
 * EE = event end
 * PP = primary progress (white)
 * SP = secondary progress (red)
 *
 * ELW, CT and SP are same points on timeline
 * LP and PP are same points on timeline
 *
 * SP = CT - ES
 * PP = CT - LW + LP
 * */

class PlayerUINoControlsViewModel(
    epgRepository: EpgRepository,
    metadataRepository: MetadataRepository,
    dateTimeRepository: DateTimeRepository,
    resourceRepository: ResourceRepository,
    youboraAnalytics: YouboraAnalytics
) : PlayerUIViewModel(metadataRepository, dateTimeRepository, resourceRepository, youboraAnalytics) {

    init {
        channels = epgRepository.getAllChannelsLD()
    }

    //region PlayerUIViewModel overrides

    @Suppress("SpellCheckingInspection")
    override fun seekToSelectedPos(player: SmartPlayer?, isInTrick: Boolean) {
        // nothing
    }

    override fun getSeekingRuleTypeInternal() = SmartSeekingRuleType.LIVE_ONLY

    override fun resetPauseTime() {
        // nothing
    }

    override fun setPauseTime() {
        // nothing
    }

    override fun onPlayerTimeUpdate(position: Long, duration: Long) {
        // nothing
    }

    override fun onPlayerActionStop() {
        // nothing
    }

    override fun startSeekingPrepare() {
        // nothing
    }

    override fun seekTick(streamDuration: Long?, seekIncrement: Int, seekMultiplier: Int): Int {
        return 0
    }

    override fun getNextChannelReference(): SmartMediaReference? = null

    override fun getPreviousChannelReference(): SmartMediaReference? = null

    override fun softZapNextChannel() {
        // nothing
    }

    override fun softZapPreviousChannel() {
        // nothing
    }

    override fun cancelSoftZap() {
        // nothing
    }

    override fun softZaping(): Boolean {
        return false
    }

    override fun getChannelReferenceByNumber(number: String): SmartMediaReference? {
        return try {
            getChannelByNumber(number.toInt())?.reference
        } catch (e: Throwable) {
            null
        }
    }

    override fun getClosestChannelReferenceByNumber(number: String): SmartMediaReference? {
        return try {
            getClosestChannelByNumber(number.toInt(), channels.value)?.reference
        } catch (e: Throwable) {
            null
        }
    }

    override fun cancelSeeking() {
        // nothing
    }

    override fun getPlayingEventStart(): Long {
        return TimeProvider.nowMs()
    }

    override fun isTimeShifted(): Boolean {
        return false
    }

    override fun observeMediaStreamLD(
        detail: SmartMediaDetail,
        channel: SmartMediaItem?,
        doBlock: (stream: SmartMediaStream) -> Unit,
        catchBlock: suspend CoroutineScope.(e: Exception) -> Boolean,
        lifecycleOwner: LifecycleOwner,
        isPlayingCatchup: Boolean
    ) {
        // nothing
    }

    override fun setPlayingChannel(channel: SmartMediaItem) {
        // nothing
    }
    //endregion
}