package com.twentyfouri.tvlauncher.viewmodels

import android.view.View
import androidx.lifecycle.LiveData
import androidx.lifecycle.Transformations
import androidx.lifecycle.ViewModel
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.data.SmartApiRepository
import com.twentyfouri.tvlauncher.common.utils.NetworkConnectionState
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import com.twentyfouri.tvlauncher.utils.Navigator
import timber.log.Timber

class OfflineRowViewModel(
    private val navigator: Navigator,
    private val resourceRepository: ResourceRepository
) : ViewModel() {

    val goOnlineText: LiveData<String> = Transformations.map(NetworkConnectionState.instance.stateLD) { state ->
        resourceRepository.getString(when (state) {
            NetworkConnectionState.State.ONLINE ->
                if (SmartApiRepository.isServerBusy) R.string.error_retry else R.string.connectivity_issues_online_button
            else -> R.string.connectivity_issues_restart_button
        })
    }

    val settingsVisibility = if (SmartApiRepository.isServerBusy) View.GONE else View.VISIBLE

    val dialogTitleText = if (SmartApiRepository.isServerBusy) {
        resourceRepository.getString(R.string.too_many_requests_message)
    } else {
        resourceRepository.getString(R.string.connectivity_issues_dialog_message)
    }

    fun goOnlineClick(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Row item 0 selected: ${goOnlineText.value} ")
        navigator.navigateCustom(Navigator.NAVIGATE_CUSTOM_FORCE_RESTART)
    }

    fun settingsClick(v: View) {
        Timber.tag(OselToggleableLogger.TAG_UI_LOG).d("Row item 1 selected: ${resourceRepository.getString(R.string.connectivity_issues_settings_button)} ")
        navigator.navigateCustom(Navigator.NAVIGATE_CUSTOM_SETTINGS_RESTART)
    }
}