package com.twentyfouri.tvlauncher.viewmodels

import com.twentyfouri.smartmodel.model.dashboard.SmartMediaType
import com.twentyfouri.smartmodel.model.dashboard.SmartPlaylistFilter
import com.twentyfouri.smartmodel.model.dashboard.SmartPlaylistFilterReference
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.common.provider.TimeProvider
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.widgets.SettingsItemType
import org.joda.time.DateTime
import org.joda.time.DateTimeComparator
import org.joda.time.format.DateTimeFormat
import java.util.*

class FilterContentViewModel(
    type: Type,
    filters: List<SmartPlaylistFilter>,
    selectedFiltersReferences: Collection<SmartPlaylistFilterReference>,
    resourceRepository: ResourceRepository,
) : FilterViewModel(type, filters, selectedFiltersReferences, resourceRepository) {

    override fun getTitle(): String {
        val selectedFilterReference = selectedFiltersReferences.find { Flavor().getFilterType(it) == type }
        return selectedFilterReference?.getTranslatedTitle() ?: type.getAllTitle()
    }

    override fun getPickerItem(filter: SmartPlaylistFilter): ListPickerItem {
        return ListPickerItem(
            id = filter.reference.hashCode().toString(),
            label = filter.reference.getTranslatedTitle() ?: "",
            title = "",
            subtitle = "",
            type = SettingsItemType.LABEL
        )
    }

    private fun SmartPlaylistFilterReference.getTranslatedTitle() =
        Flavor().getFilterContentTranslation(this, resourceRepository)
}