package com.twentyfouri.tvlauncher.utils

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.os.Handler
import android.view.View
import com.twentyfouri.tvlauncher.databinding.RowViewBinding

object RowPageAnimationHelper {

    fun doCategoryRowFocusedAnimation(binding: RowViewBinding) {
        val doAfterAnim: () -> Unit = { binding.rowViewModel?.isFocused?.postValue(false) }

        // row content smaller
        val bannerA = ObjectAnimator.ofFloat(binding.list, View.SCALE_X, 0.8f)
        val bannerB = ObjectAnimator.ofFloat(binding.list, View.SCALE_Y, 0.8f)
        // row content right bottom
        val bannerC = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_X, 20.0f)
        val bannerD = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, -20.0f)
        // category right bottom
        val bannerE = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_X, 20.0f)
        val bannerF = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, -20.0f)
        // titles change
        val bannerG = ObjectAnimator.ofFloat(binding.rowTitleHorizontal, View.ALPHA, 1.0f)
        val bannerH = ObjectAnimator.ofFloat(binding.rowTitleVertical, View.ALPHA, 0.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerA, bannerB, bannerC, bannerD, bannerE, bannerF, bannerG, bannerH)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
                doAfterAnim.invoke()
            }
        })
        Handler().post{
            animSet.start()
        }
    }

    fun doCategoryContentFocusedAnimation(binding: RowViewBinding) {
        // row content bigger
        val bannerA = ObjectAnimator.ofFloat(binding.list, View.SCALE_X, 1.0f)
        val bannerB = ObjectAnimator.ofFloat(binding.list, View.SCALE_Y, 1.0f)
        // row content left top
        val bannerC = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_X, -20.0f)
        val bannerD = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, 20.0f)
        // category left top
        val bannerE = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_X, -20.0f)
        val bannerF = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, 20.0f)
        // titles change
        val bannerG = ObjectAnimator.ofFloat(binding.rowTitleHorizontal, View.ALPHA, 0.0f)
        val bannerH = ObjectAnimator.ofFloat(binding.rowTitleVertical, View.ALPHA, 1.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerA, bannerB, bannerC, bannerD, bannerE, bannerF, bannerG, bannerH)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
            }
        })
        Handler().post{
            animSet.start()
        }
    }

    fun doLeftOptionsFocusedAnimation(binding: RowViewBinding) {
        binding.rowViewModel?.setSectionTitleRowFocused(true, false)
        // left options bigger
        val bannerA = ObjectAnimator.ofFloat(binding.leftOptions, View.SCALE_X, 500.0f)
        val bannerB = ObjectAnimator.ofFloat(binding.leftOptions, View.SCALE_Y, 1.0f)
        // category right
        val bannerC = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_X, 200.0f)
        val bannerD = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_Y, -20.0f)
        // list right
        val bannerE = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_X, 200.0f)
        val bannerF = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, -20.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerA, bannerB, bannerC, bannerD, bannerE, bannerF)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
            }
        })
        Handler().post{
            animSet.start()
        }
    }

    fun doLeftOptionsNotFocusedAnimation(binding: RowViewBinding) {
        // left options smaller
        val bannerA = ObjectAnimator.ofFloat(binding.leftOptions, View.SCALE_X, 1.0f)
        val bannerB = ObjectAnimator.ofFloat(binding.leftOptions, View.SCALE_Y, 1.0f)
        // category left
        val bannerC = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_X, -200.0f)
        val bannerD = ObjectAnimator.ofFloat(binding.category, View.TRANSLATION_Y, -20.0f)
        // list left
        val bannerE = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_X, -200.0f)
        val bannerF = ObjectAnimator.ofFloat(binding.list, View.TRANSLATION_Y, -20.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerA, bannerB, bannerC, bannerD, bannerE, bannerF)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
            }
        })
        Handler().post{
            animSet.start()
        }
    }

    fun doOneCategoryFocused(category: View) {
        val bannerX = ObjectAnimator.ofFloat(category, View.SCALE_X, 2.0f)
        val bannerY = ObjectAnimator.ofFloat(category, View.SCALE_Y, 2.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerX, bannerY)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
            }
        })

        Handler().post{
            animSet.start()
        }
    }

    fun doOneCategoryNotFocused(category: View) {
        val bannerX = ObjectAnimator.ofFloat(category, View.SCALE_X, 1.0f)
        val bannerY = ObjectAnimator.ofFloat(category, View.SCALE_Y, 1.0f)

        val animSet = AnimatorSet()
        animSet.playTogether(bannerX, bannerY)
        animSet.duration = 200L
        animSet.addListener(object : AnimatorListenerAdapter() {
            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
            }
        })

        Handler().post{
            animSet.start()
        }
    }
}