package com.twentyfouri.tvlauncher.utils

import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.common.ui.messagedialog.*
import com.twentyfouri.tvlauncher.common.utils.NavigatorCommon

object RecordingsDialogsHelper {

    fun showPlanSeriesRecordingDialog(
        resourceRepository: ResourceRepository,
        doRecordingRequest: () -> Unit = {},
        doAutoRecordingRequest: () -> Unit
    ) {
        if (com.twentyfouri.tvlauncher.common.Flavor().seriesRecordingsEnabled) {
            val messageDialogModel = MessageDialogModel(
                message = resourceRepository.getString(R.string.recording_plan_episode_or_series),
                optionsButtonText = arrayOf(
                    resourceRepository.getString(R.string.recording_this_episode),
                    resourceRepository.getString(R.string.recording_entire_series)
                ),
                code = MessageDialogCodes.planSeriesRecording
            )
            val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
            dialogFragment.mDismissListener = object : MessageDialogDismissListener {
                override fun onDismiss() {} //do nothing
            }
            dialogFragment.mListener = object : MessageDialogFragmentListener {
                override fun onResult(answer: MessageDialogAction): Boolean {
                    if (answer !is MessageDialogAction.Result) {
                        return false
                    }
                    when (answer.type) {
                        OPTION_A -> doRecordingRequest.invoke()
                        OPTION_B -> doAutoRecordingRequest.invoke()
                        CANCEL -> {
                        } //cancel, do nothing
                        else -> {
                        }
                    }
                    return false
                }
            }
            NavigatorCommon.getInstance().navigateDialog(dialogFragment)
        } else {
            doRecordingRequest.invoke()
        }
    }

    fun showUnplanSeriesRecordingDialog(
        resourceRepository: ResourceRepository,
        doRecordingRequest: () -> Unit = {},
        doAutoRecordingRequest: () -> Unit
    ) {
        if (com.twentyfouri.tvlauncher.common.Flavor().seriesRecordingsEnabled) {
            val messageDialogModel = MessageDialogModel(
                message = resourceRepository.getString(R.string.recording_unplan_episode_or_series),
                optionsButtonText = arrayOf(
                    resourceRepository.getString(R.string.recording_this_recording),
                    resourceRepository.getString(R.string.recording_all_recordings)
                ),
                code = MessageDialogCodes.unplanSeriesRecording
            )
            val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
            dialogFragment.mDismissListener = object : MessageDialogDismissListener {
                override fun onDismiss() {} //do nothing
            }
            dialogFragment.mListener = object : MessageDialogFragmentListener {
                override fun onResult(answer: MessageDialogAction): Boolean {
                    if (answer !is MessageDialogAction.Result) {
                        return false
                    }
                    when (answer.type) {
                        OPTION_A -> doRecordingRequest.invoke()
                        OPTION_B -> doAutoRecordingRequest.invoke()
                        CANCEL -> {
                        } //cancel, do nothing
                        else -> {
                        }
                    }
                    return false
                }
            }
            NavigatorCommon.getInstance().navigateDialog(dialogFragment)
        } else {
            doRecordingRequest.invoke()
        }
    }

    fun showDeleteSeriesRecordingDialog(
        resourceRepository: ResourceRepository,
        doRecordingRequest: () -> Unit = {},
        doAutoRecordingRequest: () -> Unit
    ) {
        if (com.twentyfouri.tvlauncher.common.Flavor().seriesRecordingsEnabled) {
            val messageDialogModel = MessageDialogModel(
                message = resourceRepository.getString(R.string.recording_delete_episode_or_series),
                optionsButtonText = arrayOf(
                    resourceRepository.getString(R.string.recording_this_episode),
                    resourceRepository.getString(R.string.recording_entire_series)
                ),
                code = MessageDialogCodes.deleteSeriesRecording
            )
            val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
            dialogFragment.mDismissListener = object : MessageDialogDismissListener {
                override fun onDismiss() {} //do nothing
            }
            dialogFragment.mListener = object : MessageDialogFragmentListener {
                override fun onResult(answer: MessageDialogAction): Boolean {
                    if (answer !is MessageDialogAction.Result) {
                        return false
                    }
                    when (answer.type) {
                        OPTION_A -> doRecordingRequest.invoke()
                        OPTION_B -> doAutoRecordingRequest.invoke()
                        CANCEL -> {
                        } //cancel, do nothing
                        else -> {
                        }
                    }
                    return false
                }
            }
            NavigatorCommon.getInstance().navigateDialog(dialogFragment)
        } else {
            doRecordingRequest.invoke()
        }
    }

    fun showStorageFullDialog(
            resourceRepository: ResourceRepository,
            showUserRecordings: () -> Unit = {}
    ) {
        val messageDialogModel = MessageDialogModel(
                message = resourceRepository.getString(R.string.recording_full_storage_episode_or_series),
                optionsButtonText = arrayOf(
                        resourceRepository.getString(R.string.recording_show_recordings),
                        resourceRepository.getString(R.string.recording_cancel)
                ),
                code = MessageDialogCodes.fullStorage
        )
        val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
        dialogFragment.mDismissListener = object : MessageDialogDismissListener {
            override fun onDismiss() {} //do nothing
        }
        dialogFragment.mListener = object : MessageDialogFragmentListener {
            override fun onResult(answer: MessageDialogAction): Boolean {
                if (answer !is MessageDialogAction.Result) {
                    return false
                }
                when (answer.type) {
                    OPTION_A -> showUserRecordings.invoke()
                    OPTION_B -> dialogFragment.dismiss()
                    CANCEL -> {
                    } //cancel, do nothing
                    else -> {
                    }
                }
                return false
            }
        }
        NavigatorCommon.getInstance().navigateDialog(dialogFragment)
    }

    fun showStorageAlmostFullDialog10(
        resourceRepository: ResourceRepository,
        showUserRecordings: () -> Unit = {}
    ) {
        val messageDialogModel = MessageDialogModel(
            message = resourceRepository.getString(R.string.recording_almost_full_storage_episode_or_series_10),
            optionsButtonText = arrayOf(
                resourceRepository.getString(R.string.recording_show_recordings),
                resourceRepository.getString(R.string.recording_cancel)
            ),
            code = MessageDialogCodes.fullStorage
        )
        val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
        dialogFragment.mDismissListener = object : MessageDialogDismissListener {
            override fun onDismiss() {} //do nothing
        }
        dialogFragment.mListener = object : MessageDialogFragmentListener {
            override fun onResult(answer: MessageDialogAction): Boolean {
                if (answer !is MessageDialogAction.Result) {
                    return false
                }
                when (answer.type) {
                    OPTION_A -> showUserRecordings.invoke()
                    OPTION_B -> dialogFragment.dismiss()
                    CANCEL -> {
                    } //cancel, do nothing
                    else -> {
                    }
                }
                return false
            }
        }
        NavigatorCommon.getInstance().navigateDialog(dialogFragment)
    }

    fun showStorageAlmostFullDialog25(
        resourceRepository: ResourceRepository,
        showUserRecordings: () -> Unit = {}
    ) {
        val messageDialogModel = MessageDialogModel(
            message = resourceRepository.getString(R.string.recording_almost_full_storage_episode_or_series_25),
            optionsButtonText = arrayOf(
                resourceRepository.getString(R.string.recording_show_recordings),
                resourceRepository.getString(R.string.recording_cancel)
            ),
            code = MessageDialogCodes.fullStorage
        )
        val dialogFragment = MessageDialogFragment.newInstance(messageDialogModel)
        dialogFragment.mDismissListener = object : MessageDialogDismissListener {
            override fun onDismiss() {} //do nothing
        }
        dialogFragment.mListener = object : MessageDialogFragmentListener {
            override fun onResult(answer: MessageDialogAction): Boolean {
                if (answer !is MessageDialogAction.Result) {
                    return false
                }
                when (answer.type) {
                    OPTION_A -> showUserRecordings.invoke()
                    OPTION_B -> dialogFragment.dismiss()
                    CANCEL -> {
                    } //cancel, do nothing
                    else -> {
                    }
                }
                return false
            }
        }
        NavigatorCommon.getInstance().navigateDialog(dialogFragment)
    }

}