package com.twentyfouri.tvlauncher.utils

import android.animation.TimeAnimator
import android.content.res.Resources
import android.view.View
import android.view.animation.AccelerateDecelerateInterpolator
import androidx.leanback.R
import androidx.leanback.graphics.ColorOverlayDimmer
import androidx.leanback.widget.FocusHighlight.*
import androidx.leanback.widget.ShadowOverlayContainer
import androidx.leanback.widget.ShadowOverlayHelper

/**this class is not here to be used, it's just for inspiration
 * TODO delete it occasionally*/
object FocusHelper {
    /**@param zoomIndex One of {@link FocusHighlight#ZOOM_FACTOR_SMALL}
     * {@link FocusHighlight#ZOOM_FACTOR_XSMALL}
     * {@link FocusHighlight#ZOOM_FACTOR_MEDIUM}
     * {@link FocusHighlight#ZOOM_FACTOR_LARGE}
     * {@link FocusHighlight#ZOOM_FACTOR_NONE}.
     * @param useDimmer Allow dimming browse item when unselected.
     * @param adapter  adapter of the list row.*/
    fun setupBrowseItemFocusHighlight(
//        adapter: YoufoneCardViewAdapter, zoomIndex: Int,
        useDimmer: Boolean
    ) {
//        adapter.focusHighlightHandler = BrowseItemFocusHighlight(zoomIndex, useDimmer)
    }

    private fun isValidZoomIndex(zoomIndex: Int): Boolean {
        return zoomIndex == ZOOM_FACTOR_NONE || getResId(zoomIndex) > 0
    }

    private fun getResId(zoomIndex: Int): Int {
        return when (zoomIndex) {
            ZOOM_FACTOR_SMALL -> R.fraction.lb_focus_zoom_factor_small
            ZOOM_FACTOR_XSMALL -> R.fraction.lb_focus_zoom_factor_xsmall
            ZOOM_FACTOR_MEDIUM -> R.fraction.lb_focus_zoom_factor_medium
            ZOOM_FACTOR_LARGE -> R.fraction.lb_focus_zoom_factor_large
            else -> 0
        }
    }

    private class BrowseItemFocusHighlight(private val mScaleIndex: Int, private val mUseDimmer: Boolean) :
        FocusHighlightHandler {

        init {
            if (!isValidZoomIndex(mScaleIndex)) {
                throw IllegalArgumentException("Unhandled zoom index")
            }
        }

        private fun getScale(res: Resources): Float {
            return if (mScaleIndex == ZOOM_FACTOR_NONE)
                1f
            else
                res.getFraction(getResId(mScaleIndex), 1, 1)
        }

        override fun onItemFocused(view: View, hasFocus: Boolean) {
            view.isSelected = hasFocus
            getOrCreateAnimator(view).animateFocus(hasFocus, false)
        }

        override fun onInitializeView(view: View) {
            getOrCreateAnimator(view).animateFocus(false, true)
        }

        private fun getOrCreateAnimator(view: View): FocusAnimator {
            var animator: FocusAnimator? = view.getTag(R.id.lb_focus_animator) as? FocusAnimator
            if (animator == null) {
                animator = FocusAnimator(
                    view, getScale(view.resources), mUseDimmer, DURATION_MS
                )
                view.setTag(R.id.lb_focus_animator, animator)
            }
            return animator
        }

        companion object {
            private val DURATION_MS = 150
        }

    }

    interface FocusHighlightHandler {
        /**
         * Called when an item gains or loses focus.
         * @hide
         *
         * @param view The view whose focus is changing.
         * @param hasFocus True if focus is gained; false otherwise.
         */
        fun onItemFocused(view: View, hasFocus: Boolean)

        /**
         * Called when the view is being created.
         */
        fun onInitializeView(view: View)
    }

    private open class FocusAnimator(
        private val mView: View,
        scale: Float,
        useDimmer: Boolean,
        private val mDuration: Int
    ) :
        TimeAnimator.TimeListener {
        private val mWrapper: ShadowOverlayContainer?
        private val mScaleDiff: Float = scale - 1f
        open var focusLevel = 0f
            set(level) {
                field = level
                val scale = 1f + mScaleDiff * level
                mView.scaleX = scale
                mView.scaleY = scale
                if (mWrapper != null) {
                    mWrapper.setShadowFocusLevel(level)
                } else {
                    ShadowOverlayHelper.setNoneWrapperShadowFocusLevel(mView, level)
                }
                if (mDimmer != null) {
                    mDimmer.setActiveLevel(level)
                    val color = mDimmer.paint.color
                    if (mWrapper != null) {
                        mWrapper.setOverlayColor(color)
                    } else {
                        ShadowOverlayHelper.setNoneWrapperOverlayColor(mView, color)
                    }
                }
            }
        private var mFocusLevelStart: Float = 0.toFloat()
        private var mFocusLevelDelta: Float = 0.toFloat()
        private val mAnimator = TimeAnimator()
        private val mInterpolator = AccelerateDecelerateInterpolator()
        private val mDimmer: ColorOverlayDimmer?

        fun animateFocus(select: Boolean, immediate: Boolean) {
            endAnimation()
            val end = (if (select) 1 else 0).toFloat()
            if (immediate) {
                focusLevel = end
            } else if (focusLevel != end) {
                mFocusLevelStart = focusLevel
                mFocusLevelDelta = end - mFocusLevelStart
                mAnimator.start()
            }
        }

        init {
            if (mView is ShadowOverlayContainer) {
                mWrapper = mView
            } else {
                mWrapper = null
            }
            mAnimator.setTimeListener(this)
            if (useDimmer) {
                mDimmer = ColorOverlayDimmer.createDefault(mView.context)
            } else {
                mDimmer = null
            }
        }

        fun endAnimation() {
            mAnimator.end()
        }

        override fun onTimeUpdate(animation: TimeAnimator, totalTime: Long, deltaTime: Long) {
            var fraction: Float
            if (totalTime >= mDuration) {
                fraction = 1f
                mAnimator.end()
            } else {
                fraction = (totalTime / mDuration.toDouble()).toFloat()
            }
            if (mInterpolator != null) {
                fraction = mInterpolator.getInterpolation(fraction)
            }
            focusLevel = mFocusLevelStart + fraction * mFocusLevelDelta
        }
    }
}