package com.twentyfouri.tvlauncher.utils

import com.twentyfouri.tvlauncher.common.utils.TextFileTree
import com.twentyfouri.tvlauncher.common.utils.logging.OselToggleableLogger
import timber.log.Timber

class DebugTree : Timber.DebugTree() {

    override fun isLoggable(tag: String?, priority: Int): Boolean {
        return tag !in TAG_EXCLUDE_SELECTION &&
                super.isLoggable(
                    tag,
                    priority
                )
    }

    //if some of logs spam too much just uncomment its line and it will be excluded
    //  !! this is applied only for Logcat logging, OSEL logging into file is not affected
    private val TAG_EXCLUDE_SELECTION: List<String> = listOf(
        OselToggleableLogger.TAG_HTTP_LOG,
//        OselToggleableLogger.TAG_PLAYER_LOG,
        OselToggleableLogger.TAG_PLAYER_STREAM_LOG,
//        OselToggleableLogger.TAG_PLAYER_ERROR_LOG,
//        OselToggleableLogger.TAG_RUN_LOG,
        OselToggleableLogger.TAG_KEY_EVENT_LOG,
//        TextFileTree.TAG_FILE_LOG,
//        OselToggleableLogger.TAG_UI_LOG
    )
}