package com.twentyfouri.tvlauncher.ui

import android.os.Bundle
import androidx.databinding.DataBindingUtil
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.data.ApiMissingException
import com.twentyfouri.tvlauncher.common.utils.DeviceInfo
import com.twentyfouri.tvlauncher.common.utils.InfoUpdated
import com.twentyfouri.tvlauncher.common.utils.SharedPreferencesUtils
import com.twentyfouri.tvlauncher.databinding.DiagnosticsSystemActivityBinding
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

class DiagnosticsSystemActivity: BaseActivity() {

    lateinit var binding: DiagnosticsSystemActivityBinding
    var deviceInfo: DeviceInfo? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        try {
            binding = DataBindingUtil.setContentView<DiagnosticsSystemActivityBinding>(
                    this,
                    R.layout.diagnostics_system_activity
            )
                    .apply {
                        lifecycleOwner = this@DiagnosticsSystemActivity
                    }
        } catch (t: ApiMissingException) {
            finish()
        }

        binding.sideInfoHeader.text = getString(R.string.di_header_device)
        binding.mainInfoText.text = ""

        val audio = "${getString(R.string.di_audio)} ${SharedPreferencesUtils.getAudioSelection(
                name = Flavor().defaultAudioSelection.first,
                language = Flavor().defaultAudioSelection.second
        ).first?.capitalize()}"
        val sublang = SharedPreferencesUtils.getSubtitleSelection(
                name = Flavor().defaultSubtitleSelection.first,
                language = Flavor().defaultSubtitleSelection.second
        ).first
        val sub = "${getString(R.string.di_subtitles)} " + when (sublang) {
            "none" -> getString(R.string.di_subtitles_no)
            else -> sublang?.capitalize()
        }

        deviceInfo = DeviceInfo(this, object : InfoUpdated {
            override suspend fun onInfoUpdated() {
                withContext(Dispatchers.Main) {
                    binding.mainInfoText.text = buildString {
                        appendLine(deviceInfo?.toString(this@DiagnosticsSystemActivity))
                        appendLine(audio)
                        append(sub)
                    }
                }
            }
        }, com.twentyfouri.tvlauncher.common.Flavor().deviceInfoConfig)
    }

    override fun onResume() {
        super.onResume()
        deviceInfo?.startAutoUpdate(this)
    }

    override fun onPause() {
        deviceInfo?.stopAutoUpdate()
        super.onPause()
    }
}
