package com.twentyfouri.tvlauncher.ui

import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.commit
import androidx.fragment.app.setFragmentResultListener
import com.google.firebase.crashlytics.FirebaseCrashlytics
import com.twentyfouri.androidcore.utils.ResourceImageSpecification
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.data.ListPickerItem
import com.twentyfouri.tvlauncher.widgets.SettingsItemType
import timber.log.Timber

class DiagnosticsActivity : BaseActivity() {

    private var menuFragment: ListPickerFragment? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.diagnostics_activity)
        buildMenu()
    }

    private fun buildMenu() {
        val menuItems = ArrayList<ListPickerItem>()

        menuItems.add(
            ListPickerItem(
                id = NET,
                title = getString(R.string.di_header_network),
                subtitle = "",
                label = "",
                icon = ResourceImageSpecification(R.drawable.ic_network),
                type = SettingsItemType.TITLE_WITH_ICON
            )
        )

        menuItems.add(
            ListPickerItem(
                id = DEVICE,
                title = getString(R.string.di_header_device),
                subtitle = "",
                label = "",
                icon = ResourceImageSpecification(R.drawable.ic_diagnostics),
                type = SettingsItemType.TITLE_WITH_ICON
            )
        )

        menuFragment = ListPickerFragment.newInstance(
            title = getString(R.string.di_menu_header),
            defaultPosition = ListPickerFragment.DEFAULT_POSITION_TOP,
            data = menuItems,
            closeAfterSelection = false
        ).also { fragment ->
            Timber.tag("DiagnosticsActivity.buildMenu").d("commit $fragment")
            FirebaseCrashlytics.getInstance().log("DiagnosticsActivity.buildMenu: commit $fragment")
            supportFragmentManager.commit { replace(R.id.diagnostics_root, fragment) }
            fragment.setFragmentResultListener(ListPickerFragment.REQUEST_KEY) { _, bundle ->
                (bundle.get(ListPickerFragment.BUNDLE_KEY_RESULT) as? ListPickerItem)?.let { item ->
                    when (item.id) {
                        NET -> startActivity(Intent(this, DiagnosticsNetworkActivity::class.java))
                        DEVICE -> startActivity(Intent(this, DiagnosticsSystemActivity::class.java))
                        else -> {}
                    }
                }
            }
        }
    }

    private companion object {
        const val NET = "net"
        const val DEVICE = "device"
    }
}