package com.twentyfouri.tvlauncher.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.common.analytics.YouboraAnalytics
import com.twentyfouri.tvlauncher.common.ui.MainActivityAction
import timber.log.Timber

class ScreenOnOffReceiver(private val mainActivityAction: MainActivityAction): BroadcastReceiver() {

    companion object {
        var screenWasOff = false
    }

    override fun onReceive(context: Context?, intent: Intent?) {
        Timber.d("Action: ${intent?.action}")
        when (intent?.action) {
            Intent.ACTION_SCREEN_OFF -> {
                try {
                    context?.also { YouboraAnalytics.getInstance(it).reportScreenOffEvent(it) }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                screenWasOff = true
                if (Flavor().stopPlayerInStandby) mainActivityAction.stopPlayerInStandby()
            }
            Intent.ACTION_SCREEN_ON -> {
                try {
                    context?.also { YouboraAnalytics.getInstance(it).reportScreenOnEvent(it) }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
                if (screenWasOff && Flavor().restartAfterStandby) mainActivityAction.planRestartActivity()
            }
            else -> {}
        }
    }
}