package com.twentyfouri.tvlauncher.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.twentyfouri.tvlauncher.common.utils.SharedPreferencesUtils
import timber.log.Timber

class PowerOffReceiver: BroadcastReceiver() {

    companion object {
        const val SHUTDOWN_INTENT = "android.intent.action.ACTION_SHUTDOWN"
    }
    override fun onReceive(context: Context?, intent: Intent?) {
        Timber.d("intent action ${intent?.action}")
        SharedPreferencesUtils.putLastShutDownTime()
    }
}