package com.twentyfouri.tvlauncher.notifications

import android.database.Cursor
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.drawable.Icon
import android.os.Parcel

@Suppress("unused")
class TvNotification(
    val notificationKey: String?,
    val packageName: String?,
    val title: String?,
    val text: String?,
    val isDismissible: Boolean?,
    val isOngoing: Boolean?,
    val smallIcon: Icon?,
    val channel: Int?,
    val progress: Int,
    val progressMax: Int,
    private val mHasContentIntent: Boolean?,
    val bigPicture: Bitmap?,
    val contentButtonLabel: String?, val dismissButtonLabel: String?, val tag: String?
) {

    fun hasContentIntent(): Boolean {
        return mHasContentIntent ?: false
    }

    companion object {
        /**
         * This projection MUST be used for the query when using [.fromCursor].
         */
        val PROJECTION = arrayOf(
            NotificationsContract.COLUMN_SBN_KEY,
            NotificationsContract.COLUMN_PACKAGE_NAME,
            NotificationsContract.COLUMN_NOTIF_TITLE,
            NotificationsContract.COLUMN_NOTIF_TEXT,
            NotificationsContract.COLUMN_DISMISSIBLE,
            NotificationsContract.COLUMN_ONGOING,
            NotificationsContract.COLUMN_SMALL_ICON,
            NotificationsContract.COLUMN_CHANNEL,
            NotificationsContract.COLUMN_PROGRESS,
            NotificationsContract.COLUMN_PROGRESS_MAX,
            NotificationsContract.COLUMN_HAS_CONTENT_INTENT,
            NotificationsContract.COLUMN_BIG_PICTURE,
            NotificationsContract.COLUMN_CONTENT_BUTTON_LABEL,
            NotificationsContract.COLUMN_DISMISS_BUTTON_LABEL,
            NotificationsContract.COLUMN_TAG
        )

        const val COLUMN_INDEX_KEY = 0
        const val COLUMN_INDEX_PACKAGE_NAME = 1
        const val COLUMN_INDEX_NOTIF_TITLE = 2
        const val COLUMN_INDEX_NOTIF_TEXT = 3
        const val COLUMN_INDEX_DISMISSIBLE = 4
        const val COLUMN_INDEX_ONGOING = 5
        const val COLUMN_INDEX_SMALL_ICON = 6
        const val COLUMN_INDEX_CHANNEL = 7
        const val COLUMN_INDEX_PROGRESS = 8
        const val COLUMN_INDEX_PROGRESS_MAX = 9
        const val COLUMN_INDEX_HAS_CONTENT_INTENT = 10
        const val COLUMN_INDEX_BIG_PICTURE = 11
        const val COLUMN_INDEX_CONTENT_BUTTON_LABEL = 12
        const val COLUMN_INDEX_DISMISS_BUTTON_LABEL = 13
        const val COLUMN_INDEX_TAG = 14

        // Converts cursor returned from query with PROJECTION
        fun fromCursor(cursor: Cursor): TvNotification {
            var index = 0
            val key = cursor.getString(index++)
            val packageName = cursor.getString(index++)
            val title = cursor.getString(index++)
            val text = cursor.getString(index++)
            val dismissible = cursor.getInt(index++) != 0
            val ongoing = cursor.getInt(index++) != 0
            val smallIconData = cursor.getBlob(index++)
            val smallIcon = getIconFromBytes(smallIconData)

            val channel = cursor.getInt(index++)
            val progress = cursor.getInt(index++)
            val progressMax = cursor.getInt(index++)
            val hasContentIntent = cursor.getInt(index++) != 0
            val bigPictureData = cursor.getBlob(index++)
            val bigPicture = getBitmapFromBytes(bigPictureData)
            val contentButtonLabel = cursor.getString(index++)
            val dismissButtonLabel = cursor.getString(index++)
            val tag = cursor.getString(index)

            return TvNotification(
                key, packageName, title, text, dismissible, ongoing,
                smallIcon, channel, progress, progressMax, hasContentIntent, bigPicture,
                contentButtonLabel, dismissButtonLabel, tag
            )
        }

        private fun getBitmapFromBytes(blob: ByteArray?): Bitmap? {
            return if (blob != null) {
                BitmapFactory.decodeByteArray(blob, 0, blob.size)
            } else null

        }

        private fun getIconFromBytes(blob: ByteArray?): Icon? {
            val input = Parcel.obtain()
            var icon: Icon? = null
            if (blob != null) {
                input.unmarshall(blob, 0, blob.size)
                input.setDataPosition(0)
                icon = input.readParcelable(Icon::class.java.classLoader)
            }

            input.recycle()
            return icon
        }
    }
}

