package com.twentyfouri.tvlauncher.homepagechannels.room

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import java.io.Serializable

/**
 * The class represents video entity with title, description, image thumbs and video url.
 */
@Entity(tableName = "homepage_channel_item")
data class HomepageChannelItem(

    @ColumnInfo(name = "id")
    val id: Long = 0,

    @ColumnInfo(name = "title")
    val title: String? = null,

    @ColumnInfo(name = "description")
    val description: String? = null,

    @ColumnInfo(name = "date")
    val date: String? = null,

    @ColumnInfo(name = "background_image_url")
    val backgroundImageUrl: String? = null,

    @ColumnInfo(name = "card_image_url")
    val cardImageUrl: String? = null,

    @ColumnInfo(name = "iconUrl")
    val iconUrl: String? = null,

    @ColumnInfo(name = "video_url")
    val videoUrl: String? = null,

    @ColumnInfo(name = "studio")
    val studio: String? = null,

    @ColumnInfo(name = "category")
    val category: String? = null,

    // Program id / Watch Next id returned from the TV Provider.
    @PrimaryKey
    @ColumnInfo(name = "program_id")
    var programId: Long = 0,

    @ColumnInfo(name = "watch_next_id")
    val watchNextId: Long = 0,

    @ColumnInfo(name = "app_link_uri")
    val appLinkUri: String? = null,

    @ColumnInfo(name = "channel_id")
    var channelId: Long = 0
) : Serializable {

    companion object {
        const val serialVersionUID = 727566175075960653L
    }
}