package com.twentyfouri.tvlauncher.homepagechannels.room

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters

@Database(
    entities = [
        HomepageChannel::class,
        HomepageChannelItem::class
    ],
    version = 3,
    exportSchema = false
)
@TypeConverters(HomepageChannel::class)
abstract class HomepageChannelDatabase : RoomDatabase() {
    abstract val homepageChannelDAO: HomepageChannelDAO

    companion object {
        @Volatile
        private var privateInstance: HomepageChannelDatabase? = null

        @JvmStatic
        fun getInstance(context: Context): HomepageChannelDatabase = synchronized(this) {
            return privateInstance ?: Room
                .databaseBuilder(
                    context.applicationContext,
                    HomepageChannelDatabase::class.java,
                    "homepage_channel_database")
                .fallbackToDestructiveMigration()
                .build()
                .also { privateInstance = it }
        }
    }
}