package com.twentyfouri.tvlauncher.homepagechannels.room

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverter

/** Contains the data about a channel that will be displayed on the launcher.  */
@Entity(tableName = "homepage_channel")
data class HomepageChannel(

    @PrimaryKey
    @ColumnInfo(name = "channel_id")
    var channelId: Long = 0,

    @ColumnInfo(name = "name")
    val name: String? = null,

    @ColumnInfo(name = "description")
    val description: String? = null,

    @ColumnInfo(name = "app_link_intent_uri")
    val appLinkIntentUri: String? = null,

    @ColumnInfo(name = "channel_logo")
    val channelLogo: Int = 0,

    @ColumnInfo(name = "type")
    val type: Type = Type.UNKNOWN
) {
    enum class Type {
        ALL_CHANNELS,
        ON_NOW,
        UNKNOWN
    }

    @TypeConverter
    fun toType(value: String) = enumValueOf<Type>(value)

    @TypeConverter
    fun fromType(value: Type) = value.name
}