package com.twentyfouri.tvlauncher.extensions

import com.twentyfouri.smartmodel.epg.DATABASE_NAME
import com.twentyfouri.tvlauncher.common.Flavor
import com.twentyfouri.tvlauncher.common.utils.*
import com.twentyfouri.tvlauncher.ui.MainActivity

internal fun MainActivity.initOSEL() {
    with(onScreenLogger) {
        setOutput(binding.oselDebug)
        addOSEL(OSELAppInfo(this))
        addOSEL(OSELMemoryInfo(this))
        addOSEL(OSELSession(this, this@initOSEL))
        addOSEL(OSELNetStats(this, this@initOSEL))
        addOSEL(OSELNetworkLAN(this, this@initOSEL))
        addOSEL(OSELNetworkWIFI(this, this@initOSEL))
        addOSEL(OSELEPG(this) {
            val epgDatabaseSizeMB =
                applicationContext.getDatabasePath(DATABASE_NAME).length() / (1024L * 1024L)
            val maxAllowedEpgDatabaseSize = Flavor().epgDatabaseMaximumSizeMB
            buildString {
                appendLine("DB size: $epgDatabaseSizeMB MB")
                append("DB size limit: $maxAllowedEpgDatabaseSize MB")
            }
        })
        addOSEL(OSELCrash(this))
        addOSEL(OSELExceptions(this))
        addOSEL(OSELConnectivity(this, this@initOSEL))
        addOSEL(OSELKeylog(this))
        addOSEL(OSELPlayerErrorLog(this))
    }
}