package com.twentyfouri.tvlauncher.extensions

import android.content.Context
import com.twentyfouri.tvlauncher.R
import com.twentyfouri.tvlauncher.common.provider.TimeProvider
import org.joda.time.DateTime
import org.joda.time.DateTimeComparator
import org.joda.time.format.DateTimeFormat
import java.util.*

val DateTime.isToday: Boolean
    get() = isSameDay(DateTime.now())

fun DateTime.isSameDay(dateTime: DateTime): Boolean =
    DateTimeComparator.getDateOnlyInstance().compare(this, dateTime) == 0

fun Date.toDateTime(): DateTime = DateTime(this)

fun Date.dateToString(dayOnly: Boolean, context: Context): String {
    val dateTime = this.toDateTime()
    val today = TimeProvider.now()
    return when {
        dateTime.isToday -> context.getString(R.string.epg_date_today)
        dateTime.isSameDay(today.minusDays(1)) -> context.getString(R.string.epg_date_yesterday)
        dateTime.isSameDay(today.plusDays(1)) -> context.getString(R.string.epg_date_tomorrow)
        else -> {
            val pattern = if (dayOnly) "EEEE" else "EEEE, d MMMM"
            val formatter = DateTimeFormat.forPattern(pattern).withLocale(Locale.getDefault())
            formatter.print(dateTime).capitalize()
        }
    }
}