package com.twentyfouri.tvlauncher.delegates

import android.content.res.AssetManager
import com.twentyfouri.tvlauncher.BuildConfig

abstract class SearchableDelegate {

    private var searchableCatchupsApkFileName: String? = null
    private var searchableChannelsApkFileName: String? = null
    private var searchableLiveTVsApkFileName: String? = null
    private var searchableRecordingsApkFileName: String? = null

    @JvmOverloads
    protected fun buildSearchableAppsInfo(
        assetsManager: AssetManager,
        addSearchableCatchUps: Boolean = false,
        addSearchableChannels: Boolean = false,
        addSearchableLiveTvs: Boolean = false,
        addSearchableRecordings: Boolean = false
    ): HashMap<String, String> {
        initApkFileNames(assetsManager)

        val searchableAppsInfo = hashMapOf<String, String>()
        val targetSearchPackage = "com.twentyfouri.searchproxy.${BuildConfig.FLAVOR_product}launcher"

        val searchableCatchupsPackageName = "${targetSearchPackage}.catchups"
        val searchableChannelsPackageName = "${targetSearchPackage}.channels"
        val searchableLiveTVsPackageName = "${targetSearchPackage}.livetvs"
        val searchableRecordingsPackageName = "${targetSearchPackage}.recordings"

        searchableCatchupsApkFileName?.let {
            if (addSearchableCatchUps) searchableAppsInfo[searchableCatchupsPackageName] = it
        }

        searchableChannelsApkFileName?.let {
            if (addSearchableChannels) searchableAppsInfo[searchableChannelsPackageName] = it
        }

        searchableLiveTVsApkFileName?.let {
            if (addSearchableLiveTvs) searchableAppsInfo[searchableLiveTVsPackageName] = it
        }

        searchableRecordingsApkFileName?.let {
            if (addSearchableRecordings) searchableAppsInfo[searchableRecordingsPackageName] = it
        }

        return searchableAppsInfo
    }

    private fun initApkFileNames(assetsManager: AssetManager) {
        val files = assetsManager.list("")
        files?.forEach { file ->
            when {
                file.contains("catchup", true) -> {
                    searchableCatchupsApkFileName = file
                }
                file.contains("channel", true) -> {
                    searchableChannelsApkFileName = file
                }
                file.contains("livetv", true) -> {
                    searchableLiveTVsApkFileName = file
                }
                file.contains("recording", true) -> {
                    searchableRecordingsApkFileName = file
                }
            }
        }
    }


    abstract fun getSearchableAppsInfo(assetsManager: AssetManager): HashMap<String, String>
}