package com.twentyfouri.tvlauncher.delegates

import android.content.Intent
import android.content.pm.ResolveInfo
import com.twentyfouri.androidcore.epg.model.EpgChannel
import com.twentyfouri.androidcore.utils.ImageSpecification
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaItem
import com.twentyfouri.smartmodel.model.dashboard.SmartMediaReference
import com.twentyfouri.smartmodel.model.media.SmartMediaDetail
import com.twentyfouri.tvlauncher.common.data.ResourceRepository


abstract class AppChannelsDelegate {
    abstract fun getAppChannelMediaDetail(item: SmartMediaItem, resourceRepository: ResourceRepository): SmartMediaDetail?
    abstract fun getAppChannelMediaReference(channel: EpgChannel): SmartMediaReference?
    abstract fun getAppChannelSpecificImage(reference: SmartMediaReference, resourceRepository: ResourceRepository): ImageSpecification?
    abstract fun getAppChannelIDs(): List<String>
    abstract fun getAppIntent(info: ResolveInfo): Intent
    abstract fun getSoftZappingAppChannelIntent(reference: SmartMediaReference, prevChID: String? = null, nextChID: String? = null): Intent?
    abstract fun getRecommendedAppIntent(info: ResolveInfo): Intent
    abstract fun getFavoriteAppIntent(info: ResolveInfo): Intent
    abstract fun getAppChannelIntent(packageName: String, prevChID: String? = null, nextChID: String? = null, isNumberZapp: Boolean = false): Intent?
}

