package com.twentyfouri.tvlauncher.data.channel

import android.database.Cursor
import android.net.Uri
import androidx.tvprovider.media.tv.TvContractCompat

data class ExternalRow(
    val id: Long = 0,
    val packageName: String? = null,
    val systemChannelKey: String? = null
) {
    var displayName: String? = null
        private set
    var launchUri: String? = null
        private set
    var isLegacy: Boolean = false
        private set
    var channelLogoUri: Uri? = null

    override fun toString(): String {
        return "HomeChannel{mId= ${this.id}, mDisplayName= ${this.displayName.toString()}, mPackageName= ${this.packageName.toString()}}"
    }

    companion object {
        val PROJECTION = arrayOf(
            "_id",
            TvContractCompat.Channels.COLUMN_DISPLAY_NAME,
            TvContractCompat.Channels.COLUMN_APP_LINK_INTENT_URI,
            "system_channel_key",
            "package_name",
            "internal_provider_data"
        )

        fun fromCursor(cursor: Cursor): ExternalRow {
            val channel = ExternalRow(
                cursor.getLong(0),
                cursor.getString(4),
                cursor.getString(3)
            )
            channel.displayName = cursor.getString(1)
            channel.launchUri = cursor.getString(2)

            // TODO resolve TVRECOMMENDATIONS_PACKAGE_NAME special handling
//            if (LauncherSharedConstants.TVRECOMMENDATIONS_PACKAGE_NAME.equals(channel.packageName)) {
//                val i = index5 + 1
//                val packageNameBlob = cursor.getBlob(index5)
//                channel.packageName = String(packageNameBlob, 0, packageNameBlob.size - 1)
//                channel.isLegacy = true
//            }
            return channel
        }
    }
}
