package com.twentyfouri.tvlauncher.data

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.twentyfouri.smartmodel.FlowSmartApi
import com.twentyfouri.smartmodel.model.menu.SmartMenu
import com.twentyfouri.tvlauncher.common.data.apihandler.ApiHandler
import com.twentyfouri.tvlauncher.Flavor
import com.twentyfouri.tvlauncher.common.utils.SharedPreferencesUtils
import com.twentyfouri.tvlauncher.utils.Navigator
import timber.log.Timber

class MenuRepository(
    private val smartApi: FlowSmartApi? = null,
    private val apiHandler: ApiHandler
) {

    //private suspend fun getMenus() = smartApi?.getMenus()
    private suspend fun getMenus() = Flavor().getLauncherMenu(smartApi)
    private val menusLD = MutableLiveData<List<SmartMenu>>()

    fun getMenusLD(offline: Boolean = smartApi == null): LiveData<List<SmartMenu>> {
        val menus = HardcodedMenuMapper.getOfflineMenus()
        if (!offline) {
            apiHandler.joinPreviousOrLaunchNew(
                synchronizedJobName = "getMenusLD",
                block = {
                    Timber.tag("SessionStorage").d("getMenusLD block")
                    HardcodedMenuMapper.addServerMenusToOfflineMenus(getMenus(), menus)
                    Timber.tag("menus").d("post menus ${menus.firstOrNull()?.items?.size}")
                    menusLD.postValue(menus)
                    SharedPreferencesUtils.putRestartCounter(0)
                },
                catchBlock = {
                    Timber.tag("SessionStorage").d("getMenusLD catchBlock")
                    menusLD.postValue(menus)
                    Navigator.getInstance().navigateCustom(Navigator.NAVIGATE_CUSTOM_OFFLINE)
                    false
                })
        } else {
            menusLD.value = menus
        }
        return menusLD
    }


    companion object {
        // For Singleton instantiation
        @Volatile
        private var instance: MenuRepository? = null

        fun getInstance(smartApi: FlowSmartApi?, apiHandler: ApiHandler) = instance
            ?: synchronized(this) {
                instance ?: MenuRepository(smartApi, apiHandler).also { instance = it }
            }

        fun getInstance() = instance

        fun removeInstance() {
            instance = null
        }
    }
}