package com.twentyfouri.tvlauncher.data

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase

@Database(entities = [AppUsage::class], version = 2, exportSchema = false)
abstract class AppUsageDatabase: RoomDatabase() {
    abstract fun appUsageDao(): AppUsageDao

    companion object {

        @Volatile
        private var instance: AppUsageDatabase? = null

        fun getInstance(context: Context): AppUsageDatabase = instance ?: Room.databaseBuilder(
            context.applicationContext,
            AppUsageDatabase::class.java, "usage-database"
        )
            .fallbackToDestructiveMigration()
            .allowMainThreadQueries()
            .build()
    }
}