package com.twentyfouri.tvlauncher.data

import android.content.Context
import android.content.Intent
import android.graphics.drawable.Drawable
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.net.NetworkInfo
import android.net.wifi.WifiInfo
import android.net.wifi.WifiManager
import android.telephony.SignalStrength
import android.telephony.TelephonyManager
import com.twentyfouri.tvlauncher.common.R

class AppListItemNetwork(intent: Intent) : AppListItem(intent) {

    constructor(context: Context, intent: Intent, signalStrength: SignalStrength?, priority: Long) : this(intent) {
        this.timeOfUse = priority
        val connectivityManager = context.getSystemService(ConnectivityManager::class.java)
        val networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.activeNetwork)
        val networkInfo = connectivityManager.activeNetworkInfo
        if (networkCapabilities == null || networkInfo == null) {
            icon = null // add in futuru if necessary
            label = context.getString(R.string.network_settings_disconnected)
        } else if (networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET)) {
            icon = getEthernetDrawable(context, networkInfo)
            label = context.getString(R.string.network_settings_disconnected)
        } else if (networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)) {
            val wifiInfo = context.getSystemService(WifiManager::class.java)!!.connectionInfo
            icon = getWifiDrawable(context, networkInfo, wifiInfo)
            label = removeDoubleQuotes(wifiInfo.ssid)
        } else if (networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)) {
            icon = getCellularDrawable(context, networkInfo, signalStrength)
            label = removeDoubleQuotes(
                context.getSystemService(TelephonyManager::class.java)!!.networkOperatorName
            )
        } else {
            icon = null // add in futuru if necessary
            label = context.getString(R.string.network_settings_disconnected)
        }
    }

    private fun getEthernetDrawable(context: Context, networkInfo: NetworkInfo): Drawable? {
        return if (networkInfo.isConnected) {
            context.getDrawable(R.drawable.ethernet_active_launcher)
        } else {
            context.getDrawable(R.drawable.ethernet_no_internet_launcher)
        }
    }

    private fun getWifiDrawable(
        context: Context, networkInfo: NetworkInfo,
        wifiInfo: WifiInfo
    ): Drawable? {
        return null // add in future if necessary
    }

    private fun getCellularDrawable(
        context: Context, networkInfo: NetworkInfo,
        signalStrength: SignalStrength?
    ): Drawable? {
        return null // add in future if necessary
    }

    private fun removeDoubleQuotes(string: String?): String? {
        if (string == null) {
            return null
        }
        val length = string.length
        return if (length > 1 && string[0] == '"' && string[length - 1] == '"') {
            string.substring(1, length - 1)
        } else string
    }
}
